<?php
require("../includes/header.php");
require_once("../config/connection.php");
$query = "SELECT * FROM app_settings";
$result = $mysqli->query($query);
$row = $result->fetch_assoc();
$appname = $row['appname'];

// Check if the form has been submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Verify CSRF token
    if (!csrf_verify($_POST['csrf_token'] ?? null)) {
        http_response_code(403);
        die('Invalid CSRF token');
    }

    // Sanitize and validate inputs
    $first_name = get_str('firstName');
    $last_name = get_str('lastName');
    $email = get_email('email');
    $password = get_str('password');

    // Validate required fields
    if (empty($first_name) || empty($last_name) || empty($email)) {
        $_SESSION['error'] = "All fields except password are required.";
        header("Location: account.php");
        exit();
    }

    // Prepare update query - only update password if provided
    if (!empty($password)) {
        // Validate password strength (minimum 8 characters)
        if (strlen($password) < 8) {
            $_SESSION['error'] = "Password must be at least 8 characters long.";
            header("Location: account.php");
            exit();
        }
        
        // Hash the new password using bcrypt
        $hashedPassword = password_hash($password, PASSWORD_BCRYPT);
        
        $update_query = "UPDATE users SET first_name = ?, last_name = ?, email = ?, password = ? WHERE id = 1";
        $stmt = $mysqli->prepare($update_query);
        
        if ($stmt) {
            $stmt->bind_param("ssss", $first_name, $last_name, $email, $hashedPassword);
        }
    } else {
        // Don't update password if not provided
        $update_query = "UPDATE users SET first_name = ?, last_name = ?, email = ? WHERE id = 1";
        $stmt = $mysqli->prepare($update_query);
        
        if ($stmt) {
            $stmt->bind_param("sss", $first_name, $last_name, $email);
        }
    }

    if ($stmt && $stmt->execute()) {
        $_SESSION['success'] = "Profile has been updated successfully.";
        $stmt->close();
    } else {
        error_log("Error updating profile: " . ($stmt ? $stmt->error : $mysqli->error));
        $_SESSION['error'] = "An error occurred while updating the profile.";
        if ($stmt) $stmt->close();
    }

    header("Location: account.php");
    exit();
}

// Fetch user data
$query = "SELECT * FROM users WHERE id = 1";
$stmt = $mysqli->prepare($query);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();
} else {
    $row = null;
}
$stmt->close();
?>





    <title>Account settings</title>

    <meta name="description" content="" />

    

  <body>
    <!-- Layout wrapper -->
    <div class="layout-wrapper layout-content-navbar">
      <div class="layout-container">
        <!-- Menu -->

       <?php require("../includes/sidebar.php") ?>
       
        <!-- / Menu -->

        <!-- Layout container -->
        <div class="layout-page">
          <!-- Navbar -->

          <?php require("../includes/navbar.php") ?>  

          <!-- / Navbar -->

          <!-- Content wrapper -->
          <div class="content-wrapper">
            <!-- Content -->

            <div class="container-xxl flex-grow-1 container-p-y">
              <h4 class="fw-bold py-3 mb-4"><span class="text-muted fw-light">Account Settings /</span> Account</h4>

              <div class="row">
                <div class="col-md-12">
                  
                  <div class="card mb-4">
                    <h5 class="card-header">Profile Details</h5>
                    <!-- Account -->
                    
                    </div>
                    <hr class="my-0" />
                    <div class="card-body">
                      <form id="formAccountSettings" method="POST">
                        <?= csrf_input(); ?>
                        <div class="row">
                          <div class="mb-3 col-md-6">
                            <label for="firstName" class="form-label">First Name</label>
                            <input
                              class="form-control"
                              type="text"
                              id="firstName"
                              name="firstName"
                              value="<?= $row['first_name'] ?>"
                              autofocus
                            />
                          </div>
                          <div class="mb-3 col-md-6">
                            <label for="lastName" class="form-label">Last Name</label>
                            <input class="form-control" type="text" name="lastName" id="lastName" value="<?= $row['last_name'] ?>" />
                          </div>
                          <div class="mb-3 col-md-6">
                            <label for="email" class="form-label">E-mail</label>
                            <input
                              class="form-control"
                              type="text"
                              id="email"
                              name="email"
                              value="<?= $row['email'] ?>"
                              placeholder="Email Address"
                            />
                          </div>
                          <div class="mb-3 col-md-6">
                            <label for="password" class="form-label">Password</label>
                            <input
                              class="form-control"
                              type="password"
                              id="password"
                              name="password"
                              value=""
                              placeholder="New password"
                            />
                          </div>
                          
                        <div class="mt-2">
                          <button type="submit" class="btn btn-primary me-2">Save changes</button>
                          <button type="reset" class="btn btn-outline-secondary">Cancel</button>
                        </div>
                      </form>
                     <!--?php var_dump($baseUrl); ?-->
                    </div>
                    
                    
                    
                  </div>
                  
                </div>
              </div>
            </div>
            <!-- / Content -->
			
			  

            <!-- Footer -->
            <?php 
require("../includes/footer.php");
?>
  </body>
</html>
